/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.carver.controller;

import com.yungnickyoung.minecraft.bettercaves.BetterCaves;
import com.yungnickyoung.minecraft.bettercaves.config.util.ConfigHolder;
import com.yungnickyoung.minecraft.bettercaves.enums.CaveType;
import com.yungnickyoung.minecraft.bettercaves.util.BetterCavesUtils;
import com.yungnickyoung.minecraft.bettercaves.world.carver.CarverNoiseRange;
import com.yungnickyoung.minecraft.bettercaves.world.carver.ICarver;
import com.yungnickyoung.minecraft.bettercaves.world.carver.cave.CaveCarver;
import com.yungnickyoung.minecraft.bettercaves.world.carver.cave.CaveCarverBuilder;
import com.yungnickyoung.minecraft.bettercaves.world.carver.vanilla.VanillaCaveCarver;
import com.yungnickyoung.minecraft.bettercaves.world.carver.vanilla.VanillaCaveCarverBuilder;
import com.yungnickyoung.minecraft.yungsapi.noise.FastNoise;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;

public class CaveCarverController {
    private ISeedReader world;
    private VanillaCaveCarver surfaceCaveCarver;
    private FastNoise caveRegionSampler;
    private List<CarverNoiseRange> noiseRanges = new ArrayList<CarverNoiseRange>();
    private boolean isDebugViewEnabled;
    private boolean isOverrideSurfaceDetectionEnabled;
    private boolean isSurfaceCavesEnabled;
    private boolean isFloodedUndergroundEnabled;

    public CaveCarverController(ISeedReader worldIn, ConfigHolder config) {
        this.world = worldIn;
        this.isDebugViewEnabled = config.debugVisualizer.get();
        this.isOverrideSurfaceDetectionEnabled = config.overrideSurfaceDetection.get();
        this.isSurfaceCavesEnabled = config.isSurfaceCavesEnabled.get();
        this.isFloodedUndergroundEnabled = config.enableFloodedUnderground.get();
        this.surfaceCaveCarver = new VanillaCaveCarverBuilder().bottomY(config.surfaceCaveBottom.get()).topY(config.surfaceCaveTop.get()).density(config.surfaceCaveDensity.get()).liquidAltitude(config.liquidAltitude.get()).replaceGravel(config.replaceFloatingGravel.get()).floodedUnderground(config.enableFloodedUnderground.get()).debugVisualizerEnabled(config.debugVisualizer.get()).debugVisualizerBlock(Blocks.field_150475_bE.func_176223_P()).build();
        float caveRegionSize = this.calcCaveRegionSize(config.caveRegionSize.get(), config.caveRegionCustomSize.get().floatValue());
        this.caveRegionSampler = new FastNoise();
        this.caveRegionSampler.SetSeed((int)worldIn.func_72905_C() + 222);
        this.caveRegionSampler.SetFrequency(caveRegionSize);
        this.caveRegionSampler.SetNoiseType(FastNoise.NoiseType.Cellular);
        this.caveRegionSampler.SetCellularDistanceFunction(FastNoise.CellularDistanceFunction.Natural);
        ArrayList<ICarver> carvers = new ArrayList<ICarver>();
        carvers.add(new CaveCarverBuilder(worldIn.func_72905_C()).ofTypeFromConfig(CaveType.CUBIC, config).debugVisualizerBlock(Blocks.field_196662_n.func_176223_P()).build());
        carvers.add(new CaveCarverBuilder(worldIn.func_72905_C()).ofTypeFromConfig(CaveType.SIMPLEX, config).debugVisualizerBlock(Blocks.field_150347_e.func_176223_P()).build());
        carvers.add(new VanillaCaveCarverBuilder().bottomY(config.vanillaCaveBottom.get()).topY(config.vanillaCaveTop.get()).density(config.vanillaCaveDensity.get()).priority(config.vanillaCavePriority.get()).liquidAltitude(config.liquidAltitude.get()).replaceGravel(config.replaceFloatingGravel.get()).floodedUnderground(config.enableFloodedUnderground.get()).debugVisualizerEnabled(config.debugVisualizer.get()).debugVisualizerBlock(Blocks.field_196584_bK.func_176223_P()).build());
        carvers.removeIf(carver -> carver.getPriority() == 0);
        float maxPossibleNoiseThreshold = config.caveSpawnChance.get().floatValue() * 0.01f * 2.0f - 1.0f;
        int totalPriority = carvers.stream().map(ICarver::getPriority).reduce(0, Integer::sum);
        float totalRangeLength = maxPossibleNoiseThreshold - -1.0f;
        float currNoise = -1.0f;
        BetterCaves.LOGGER.debug("CAVE INFORMATION");
        BetterCaves.LOGGER.debug("--> MAX POSSIBLE THRESHOLD: " + maxPossibleNoiseThreshold);
        BetterCaves.LOGGER.debug("--> TOTAL PRIORITY: " + totalPriority);
        BetterCaves.LOGGER.debug("--> TOTAL RANGE LENGTH: " + totalRangeLength);
        for (ICarver carver2 : carvers) {
            BetterCaves.LOGGER.debug("--> CARVER");
            float noiseRangeLength = (float)carver2.getPriority() / (float)totalPriority * totalRangeLength;
            float rangeTop = currNoise + noiseRangeLength;
            CarverNoiseRange range = new CarverNoiseRange(currNoise, rangeTop, carver2);
            currNoise = rangeTop;
            this.noiseRanges.add(range);
            BetterCaves.LOGGER.debug("    --> RANGE FOUND: " + range);
        }
    }

    public void carveChunk(IChunk chunk, int chunkX, int chunkZ, int[][] surfaceAltitudes, BlockState[][] liquidBlocks, Function<BlockPos, Biome> biomePos, BitSet airCarvingMask, BitSet liquidCarvingMask) {
        if (this.noiseRanges.size() == 0 && !this.isSurfaceCavesEnabled) {
            return;
        }
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        boolean shouldCarveVanillaCaves = false;
        boolean[][] validPositions = new boolean[16][16];
        for (int subX = 0; subX < 4; ++subX) {
            for (int subZ = 0; subZ < 4; ++subZ) {
                int startX = subX * 4;
                int startZ = subZ * 4;
                int endX = startX + 4 - 1;
                int endZ = startZ + 4 - 1;
                BlockPos startPos = new BlockPos(chunkX * 16 + startX, 1, chunkZ * 16 + startZ);
                BlockPos endPos = new BlockPos(chunkX * 16 + endX, 1, chunkZ * 16 + endZ);
                this.noiseRanges.forEach(range -> range.setNoiseCube(null));
                int maxHeight = 0;
                if (!this.isOverrideSurfaceDetectionEnabled) {
                    for (int x = startX; x < endX; ++x) {
                        for (int z = startZ; z < endZ; ++z) {
                            maxHeight = Math.max(maxHeight, surfaceAltitudes[x][z]);
                        }
                    }
                    for (CarverNoiseRange range2 : this.noiseRanges) {
                        maxHeight = Math.max(maxHeight, range2.getCarver().getTopY());
                    }
                }
                for (int offsetX = 0; offsetX < 4; ++offsetX) {
                    block6: for (int offsetZ = 0; offsetZ < 4; ++offsetZ) {
                        boolean flooded;
                        int localX = startX + offsetX;
                        int localZ = startZ + offsetZ;
                        BlockPos colPos = new BlockPos(chunkX * 16 + localX, 1, chunkZ * 16 + localZ);
                        boolean bl = flooded = this.isFloodedUndergroundEnabled && !this.isDebugViewEnabled && biomePos.apply(colPos).func_201856_r() == Biome.Category.OCEAN;
                        if (flooded && (BetterCavesUtils.isPosInWorld((BlockPos)mutablePos.func_189533_g((Vector3i)colPos).func_189536_c(Direction.EAST), (IWorld)this.world) && biomePos.apply((BlockPos)mutablePos.func_189533_g((Vector3i)colPos).func_189536_c(Direction.EAST)).func_201856_r() != Biome.Category.OCEAN || BetterCavesUtils.isPosInWorld((BlockPos)mutablePos.func_189533_g((Vector3i)colPos).func_189536_c(Direction.WEST), (IWorld)this.world) && biomePos.apply((BlockPos)mutablePos.func_189533_g((Vector3i)colPos).func_189536_c(Direction.WEST)).func_201856_r() != Biome.Category.OCEAN || BetterCavesUtils.isPosInWorld((BlockPos)mutablePos.func_189533_g((Vector3i)colPos).func_189536_c(Direction.NORTH), (IWorld)this.world) && biomePos.apply((BlockPos)mutablePos.func_189533_g((Vector3i)colPos).func_189536_c(Direction.NORTH)).func_201856_r() != Biome.Category.OCEAN || BetterCavesUtils.isPosInWorld((BlockPos)mutablePos.func_189533_g((Vector3i)colPos).func_189536_c(Direction.SOUTH), (IWorld)this.world) && biomePos.apply((BlockPos)mutablePos.func_189533_g((Vector3i)colPos).func_189536_c(Direction.SOUTH)).func_201856_r() != Biome.Category.OCEAN)) continue;
                        int surfaceAltitude = surfaceAltitudes[localX][localZ];
                        BlockState liquidBlock = liquidBlocks[localX][localZ];
                        float caveRegionNoise = this.caveRegionSampler.GetNoise((float)colPos.func_177958_n(), (float)colPos.func_177952_p());
                        for (CarverNoiseRange range3 : this.noiseRanges) {
                            if (!range3.contains(caveRegionNoise)) continue;
                            if (range3.getCarver() instanceof CaveCarver) {
                                CaveCarver carver = (CaveCarver)range3.getCarver();
                                int bottomY = carver.getBottomY();
                                int topY = Math.min(surfaceAltitude, carver.getTopY());
                                if (this.isOverrideSurfaceDetectionEnabled) {
                                    topY = carver.getTopY();
                                    maxHeight = carver.getTopY();
                                }
                                if (this.isDebugViewEnabled) {
                                    topY = 128;
                                    maxHeight = 128;
                                }
                                if (range3.getNoiseCube() == null) {
                                    range3.setNoiseCube(carver.getNoiseGen().interpolateNoiseCube(startPos, endPos, bottomY, maxHeight));
                                }
                                double[][] noiseColumn = range3.getNoiseCube()[offsetX][offsetZ];
                                carver.carveColumn(chunk, colPos, topY, noiseColumn, liquidBlock, flooded, flooded ? liquidCarvingMask : airCarvingMask);
                                continue block6;
                            }
                            if (!(range3.getCarver() instanceof VanillaCaveCarver)) continue;
                            validPositions[localX][localZ] = true;
                            shouldCarveVanillaCaves = true;
                        }
                    }
                }
            }
        }
        if (shouldCarveVanillaCaves) {
            VanillaCaveCarver carver = null;
            for (CarverNoiseRange range4 : this.noiseRanges) {
                if (!(range4.getCarver() instanceof VanillaCaveCarver)) continue;
                carver = (VanillaCaveCarver)range4.getCarver();
                break;
            }
            if (carver != null) {
                carver.generate(this.world, chunkX, chunkZ, chunk, true, liquidBlocks, biomePos, validPositions, airCarvingMask, liquidCarvingMask);
            }
        }
        if (this.isSurfaceCavesEnabled) {
            this.surfaceCaveCarver.generate(this.world, chunkX, chunkZ, chunk, false, liquidBlocks, biomePos, airCarvingMask, liquidCarvingMask);
        }
    }

    private float calcCaveRegionSize(String caveRegionSize, float caveRegionCustomSize) {
        switch (caveRegionSize) {
            case "Small": {
                return 0.008f;
            }
            case "Large": {
                return 0.0032f;
            }
            case "ExtraLarge": {
                return 0.001f;
            }
            case "Custom": {
                return caveRegionCustomSize;
            }
        }
        return 0.005f;
    }

    public void setWorld(ISeedReader worldIn) {
        this.world = worldIn;
        this.surfaceCaveCarver.setWorld(worldIn);
        for (CarverNoiseRange range : this.noiseRanges) {
            if (!(range.getCarver() instanceof VanillaCaveCarver)) continue;
            ((VanillaCaveCarver)range.getCarver()).setWorld(worldIn);
            break;
        }
    }
}

